#-----------------------------------------------------------------------------
# Cutlist Tag Definition
#-----------------------------------------------------------------------------

# This file can add info to Parts & Assemblies.
# The general syntax is as follows:

# PartID 	 		Description				Expression
# :AssemblyID	(Maximun of 255 numbers) Description

# The "Description" is usually a short name identifying a part or an assembly
# The "Expression" is a typical Compose expression with the following syntax:

#										VarName=Expression
#	VarName can be one of the following:

#	W	 or Width
#	H	 or Height
#	D	 or Depth
#	GQ	 or GenQuantity
#	VGC1 or VGenColor1
#	PR99 or PRice99

#				<Kind>					Expression
#				<Grain>					Expression

# If one of the dimensional variables "Width", "Height" or "Depth" evaluates to 0
# the part is effectifely excluded from the part list.

# The tokens <Kind> & <Grain> can have expressions which must evaluate to a number.
#		<Kind>		0 = Make, 1 = Buy, 2, 3 = Draw, 4 = Hardware, 5 = Prompt
#					6 = NoOptimise, 7 = Plus
#		<Grain>		0 = None, 1 = Length, 2 = Width
# <Kind> can be associated with parts or assemblies.
# <Grain> is usually associated only with parts.

# Parts should provide an association between it's thickness and the Compose variable
# which the shape uses. The syntax to do this is as follows:

#				<Thickness>				VarName

# PartID's between 9991 and 9999 are reserved for UserParts. These parts do not
# exist geometrically, but can be added to the part list of items (cabinets).
# The variables "W", "H" and "D" give their outside dimensions.
# The variable "GQ" specifies the quantity requested.
# The variable "VGC1" specifies the material to be used.



#-----------------------------------------------------------------------------

# ******* Side of cabinet ******

1	Case Base Side          W=W+CW0001		
					H=H+CH0001		
					D=ST		
			<Kind>	0
			<Grain>	0

11	Case Side               W=W+CW0011		
					H=H+CH0011		
					D=ST		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# *********** Panel ************

100	Panel                   W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

110	Blind Panel             W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

120	Oven Panel              W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ******* Frame parts *******

200	Frame Stile (Diagonal)  W=STW1+SQRT((STT^2)/2)		
					H=H		
					D=STT		
			<Kind>	0
			<Grain>	1

210	Frame Rail              W=W+CW0210		
					H=H		
					D=STT		
			<Kind>	0
			<Grain>	1

211	Frame Stile             W=W+CW0211		
					H=H		
					D=STT		
			<Kind>	0
			<Grain>	1

# ----------------------------------------------------------------------------
# ******** Floor & Top *********

300	Case Floor              W=W+CW0300		
					H=H+CH0300		
					D=D		
			<Kind>	0
			<Grain>	0

301	Case Top                W=W+CW0301		
					H=H+CH0301		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ************ Back ************

400	Case Back               W=W+CW0400		
					H=H+CH0400		
					D=D		
			<Kind>	0
			<Grain>	0

410	Case Diagonal Back      W=W+CW0410		
					H=H+CH0410		
					D=D+CD0410		
			<Kind>	0
			<Grain>	0

420	Case Back               W=W+CW0400		
					H=H+CH0400		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********* Divider ************

500	Base Divider            W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0
	
510	Divider                 W=W+CW0510		
					H=H+CH0510		
					D=D		
			<Kind>	0
			<Grain>	0

520	Wine Rack Divider       W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Shelf **********

600	Adjustable Shelf        W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

610	Case Fixed Shelf        W=W+CW0610		
					H=H+CH0610		
					D=D		
			<Kind>	0
			<Grain>	0

620	Shelf                   W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

630	Shelf                   W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

640	Sliding Shelf           W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

650	Case Fixed Shelf        W=W+CW0610		
					H=H+CH0610		
					D=D		
			<Kind>	0
			<Grain>	0

660	Microwave Shelf         W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Toe Kick **********

700	Case Toe Kick           W=W+CW0700		
					H=H+CH0700		
					D=D		
			<Kind>	0
			<Grain>	0

710	Case Toe Box            W=W+CW0700		
					H=H+CH0700		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Cabinet Stretcher/Rail **********

800	Case Top Rail           W=max(W,H)		
					H=min(W,H)		
					D=D		
			<Kind>	0
			<Grain>	0

810	Corner Rail             W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Filler **********

900	Filler                  W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

910	Back Filler             W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Drawer Box **********

1000	Drawer Box Floor        W=W+CW1000		
					H=H+CH1000		
					D=D		
			<Kind>	0
			<Grain>	0

1001	Drawer Box Side         W=W+CW1001		
					H=H+CH1001		
					D=D		
			<Kind>	0
			<Grain>	0

1002	Drawer Box Front        W=W+CW1002		
					H=H+CH1002		
					D=D		
			<Kind>	0
			<Grain>	0

1003	Drawer Box Back         W=W+CW1003		
					H=H+CH1003		
					D=D		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Door/Drawer **********

1100	Base Door Center        W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1105	Base Door               W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1120	Drawer Front Center     W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1125	Drawer Front            W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1110	Wall Door Center        W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1115	Wall Door               W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1130	Mullion                 W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1135	Tambour Door            W=W		
					H=H		
					D=0.25		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Hardware **********

1200	Pull                    W=2		
					H=1		
					D=1		
			<Kind>	4
			<Grain>	0

1210	Drawer Glides           W=2		
					H=1		
					D=1		
			<Kind>	4
			<Grain>	0

1220	Glass                   W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1400	Posts                   W=W		
					H=H		
					D=D		
			<Kind>	0
			<Grain>	0

1420	Lazy Susan              W=0		
					H=0		
					D=0		
			<Kind>	4
			<Grain>	0

32000	Misc.                   W=0		
					H=0		
					D=0		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ********** Enhancer Object **********

1230	Molding			
			<Kind>	0
			<Grain>	1

1310	Counter			
			<Kind>	0
			<Grain>	1

1600	Counter			
			<Kind>	0
			<Grain>	1

1610	Counter Edge			
			<Kind>	0
			<Grain>	1

1620	Backsplash			
			<Kind>	0
			<Grain>	1

1630	Soffit			
			<Kind>	0
			<Grain>	1

1640	Top Molding			
			<Kind>	0
			<Grain>	1

1650	Bottom Molding			
			<Kind>	0
			<Grain>	1

1660	Baseboard			
			<Kind>	0
			<Grain>	1

3101	Top Molding			
			<Kind>	0
			<Grain>	1

3105	Bottom Molding			
			<Kind>	0
			<Grain>	1

3111	Backsplash			
			<Kind>	0
			<Grain>	1

3121	Counter Edge			
			<Kind>	0
			<Grain>	1

3141	Baseboard			
			<Kind>	0
			<Grain>	1

3151	Soffit			
			<Kind>	0
			<Grain>	1


# ----------------------------------------------------------------------------
# ********** User Parts **********


9991	Non-graphic part #1     W=CWPRT1		
					H=CHPRT1		
					D=CDPRT1		
					GQ=UQ1		
					VGC1=151		
			<Kind>	0
			<Grain>	0

9992	Non-graphic part #2     W=CWPRT2		
					H=CHPRT2		
					D=CDPRT2		
					GQ=UQ2		
					VGC1=152		
			<Kind>	0
			<Grain>	0

9993	Non-graphic part #3     W=CWPRT3		
					H=CHPRT3		
					D=CDPRT3		
					GQ=UQ3		
					VGC1=153		
			<Kind>	0
			<Grain>	0

9994	Non-graphic part #4     W=CWPRT4		
					H=CHPRT4		
					D=CDPRT4		
					GQ=UQ4		
					VGC1=154		
			<Kind>	0
			<Grain>	0

9995	Non-graphic part #5     W=CWPRT5		
					H=CHPRT5		
					D=CDPRT5		
					GQ=UQ5			
					VGC1=155		
			<Kind>	0
			<Grain>	0

# ----------------------------------------------------------------------------
# ******* Assemblies ******

:1		Case
		

:3		Drawer Box


:4		Face Frame

:6		Rollout Box


:16		Base Door Assembly


:17		Base Glass Door Assembly


:18		Wall Door Assembly


:19		Wall Glass Door Assembly


:20		Tall Door Assembly


:21		Tall Glass Door Assembly


:22		Drawer Front Assembly


:25		R/P Finished End Assembly


:40		Platform Toe Kick

:50		Finished Panel Filler

:60		Accessories Assembly

:61		Accessories Box

:100		Door with accessories assembly

:122		Drawer with Drawer box accessories assembly

:123		Pull-Out accessories assembly

# ----------------------------------------------------------------------------
